﻿/*
VERSION:		1.0

	These helper functions make it easier to use the menuBar
	and keep data separate from the menu itself.
	
USAGE:
	#include "functions/addMenubarFunctions.as"
	addMenubarFunctions( menuBar_mc );
	
	file_obj = {};
	file_obj.menu_xml = new XML();
	file_obj.menu_xml.addMenuItem({label:"New", functionName:"new_funct"});
	file_obj.new_funct = function(){	trace("new()");		}
	
	var fileMenu = menuBar_mc.addMenu( "File", file_obj.menu_xml.cloneNode(true) );		// pass a copy or it'll get deleted when removed
	fileMenu.parent = file_obj;		// tell the new menu where its reactions are stored
*/



addMenubarFunctions = function( menuBar_mc )
{
	// allows you get the index of a menu by name
	menuBar_mc.getMenuIndex = function( menuName )
	{
		for(var i=0; i<this.__menuBarItems.length; i++)
		{
			var thisMenu = this.__menuBarItems[i];
			if( thisMenu.__initText == menuName )
			{// if:  match found
				break;		// stop searching
			}// if:  match found
		}// for: each menu
		if(i < this.__menuBarItems.length)
			return i;
	}// getMenuIndex()
	
	
	
	// allows you to remove menus by name		(case-sensitive)
	menuBar_mc.removeMenu = function( menuName )
	{
		var thisIndex = this.getMenuIndex( menuName );
		if(thisIndex != undefined)
			this.removeMenuAt( thisIndex );
	}// removeMenu()
	
	
	
	// menu reaction
	menuBar_mc.change = function( evt )
	{
		var functionName = evt.menuItem.attributes.functionName;
		evt.menu.parent[functionName]();
	}// change()
}// addMenubarFunctions